<?php
class ControllerModuleFeaturedTabs extends Controller {
	protected function index($setting) {
		$this->language->load('module/featuredtabs');
 
      	$this->data['heading_title'] = $this->language->get('heading_title');
		$this->document->addScript('catalog/view/javascript/jquery/tabs.js');		
		$this->data['tab_bestseller'] = $this->language->get('tab_bestseller');
		$this->data['tab_featured'] = $this->language->get('tab_featured');
		$this->data['tab_latest'] = $this->language->get('tab_latest');
		$this->data['tab_special'] = $this->language->get('tab_special');
		$this->data['button_cart'] = $this->language->get('button_cart');
		$this->load->model('catalog/product');
/* start - ipl extension - dbassa */

			// bestseller
			$bestseller_products = $this->model_catalog_product->getBestSellerProducts(25);
			$bestsellers = array();
			
			foreach ($bestseller_products as $bestseller_product) {
				$bestsellers[] = $bestseller_product['product_id'];
			}
			
			// featured

			$products_featured = explode(',', $this->config->get('featured_product'));

			// labels config

			$config_labels = $this->config->get('intelligent_product_labels_module');
			if ( empty($config_labels) ) { $config_labels = array(); }

			// current class name

			$current_layout = get_class($this);

			/* end - ipl extension - dbassa */
		
		$this->load->model('tool/image');
		//bestseller(en cok satanlar)
		$this->data['bestseller_products'] = array();

		/*$results = $this->model_catalog_product->getBestSellerProducts($setting['limit']);*/
		$results = $this->model_catalog_product->getBestSellerProducts($setting['limit'] * 10);
srand((float)microtime() * 1000000);
shuffle($results); 
$results = array_slice($results, 0, $setting['limit']);
		
		foreach ($results as $result) {
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], $setting['image_width'], $setting['image_height']);
			} else {
				$image = false;
			}
			
			if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
				$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$price = false;
			}
					
			if ((float)$result['special']) {
				$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$special = false;
			}	
			
			if ($this->config->get('config_review_status')) {
				$rating = $result['rating'];
			} else {
				$rating = false;
			}
							

			/* start - ipl extension - dbassa */
			
			$mylabels = new Label($this->registry);

			$mylabels->labels = $config_labels;
			$mylabels->product_info = $result;
			$mylabels->current_layout = $current_layout;
			$mylabels->current_layout_position = $setting['position'];
			$mylabels->products_featured = $products_featured;
			$mylabels->bestsellers = $bestsellers;
			$labels = $mylabels->RenderLabels();

			/* end - ipl extension - dbassa */
			
			$this->data['bestseller_products'][] = array(

			/* start - ipl extension - dbassa */

			'labels' => $labels,

			/* end - ipl extension - dbassa */
			
				'product_id' => $result['product_id'],
				'thumb'   	 => $image,
				'name'        => substr($result['name'], 0, 85) . '',
				'price'   	 => $price,
				'special' 	 => $special,
				'rating'     => $rating,
				'quantity' => $result['quantity'],
				'tarih'         => $result['date_added'], 
				'reviews'    => sprintf($this->language->get('text_reviews'), (int)$result['reviews']),
				'href'    	 => $this->url->link('product/product', 'product_id=' . $result['product_id']),
			);
		}
		// bestseller end
		//featured(ozel urunler)
		$this->data['featured_products'] = array();

		$products = explode(',', $this->config->get('featured_product'));		

		foreach ($products as $product_id) {
			$product_info = $this->model_catalog_product->getProduct($product_id);
			
			if ($product_info) {
				if ($product_info['image']) {
					$image = $this->model_tool_image->resize($product_info['image'], $setting['image_width'], $setting['image_height']);
				} else {
					$image = false;
				}

				if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')));
				} else {
					$price = false;
				}
						
				if ((float)$product_info['special']) {
					$special = $this->currency->format($this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')));
				} else {
					$special = false;
				}
				
				if ($this->config->get('config_review_status')) {
					$rating = $product_info['rating'];
				} else {
					$rating = false;
				}
					

			/* start - ipl extension - dbassa */
			
			$mylabels = new Label($this->registry);

			$mylabels->labels = $config_labels;
			$mylabels->product_info = $result;
			$mylabels->current_layout = $current_layout;
			$mylabels->current_layout_position = $setting['position'];
			$mylabels->products_featured = $products_featured;
			$mylabels->bestsellers = $bestsellers;
			$labels = $mylabels->RenderLabels();

			/* end - ipl extension - dbassa */
			
				$this->data['featured_products'][] = array(

			/* start - ipl extension - dbassa */

			'labels' => $labels,

			/* end - ipl extension - dbassa */
			
					'product_id' => $product_info['product_id'],
					'thumb'   	 => $image,
					'name'        => substr($product_info['name'], 0, 85) . '',
					'price'   	 => $price,
					'special' 	 => $special,
					'rating'     => $rating,
					'quantity' => $product_info['quantity'],
					'tarih'         => $product_info['date_added'], 
					'reviews'    => sprintf($this->language->get('text_reviews'), (int)$product_info['reviews']),
					'href'    	 => $this->url->link('product/product', 'product_id=' . $product_info['product_id']),
				);
			}
		}
		//featured end
		//latest (yeni urunler)
		$this->data['latest_products'] = array();
		
		$data = array(
			'sort'  => 'p.date_added',
			'order' => 'DESC',
			'start' => 0,
			'limit' => ($setting['limit']*10)
		);

		$results = $this->model_catalog_product->getProducts($data);
		srand((float)microtime() * 1000000);
shuffle($results); 
$results = array_slice($results, 0, $setting['limit']);

		foreach ($results as $result) {
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], $setting['image_width'], $setting['image_height']);
			} else {
				$image = false;
			}
						
			if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
				$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$price = false;
			}
					
			if ((float)$result['special']) {
				$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$special = false;
			}
			
			if ($this->config->get('config_review_status')) {
				$rating = $result['rating'];
			} else {
				$rating = false;
			}
			

			/* start - ipl extension - dbassa */
			
			$mylabels = new Label($this->registry);

			$mylabels->labels = $config_labels;
			$mylabels->product_info = $result;
			$mylabels->current_layout = $current_layout;
			$mylabels->current_layout_position = $setting['position'];
			$mylabels->products_featured = $products_featured;
			$mylabels->bestsellers = $bestsellers;
			$labels = $mylabels->RenderLabels();

			/* end - ipl extension - dbassa */
			
			$this->data['latest_products'][] = array(

			/* start - ipl extension - dbassa */

			'labels' => $labels,

			/* end - ipl extension - dbassa */
			
				'product_id' => $result['product_id'],
				'thumb'   	 => $image,
				'name'        => substr($result['name'], 0, 85) . '',
				'price'   	 => $price,
				'special' 	 => $special,
				'rating'     => $rating,
				'quantity' => $result['quantity'],
				'tarih'         => $result['date_added'], 
				'reviews'    => sprintf($this->language->get('text_reviews'), (int)$result['reviews']),
				'href'    	 => $this->url->link('product/product', 'product_id=' . $result['product_id']),
			);
		}
		//latest end
		//special(kampanyali urunler)
		$this->data['special_products'] = array();
		
		$data = array(
			'sort'  => 'pd.name',
			'order' => 'ASC',
			'start' => 0,
			'limit' => ($setting['limit']*10)
		);

		$results = $this->model_catalog_product->getProductSpecials($data);
		srand((float)microtime() * 1000000);
shuffle($results); 
$results = array_slice($results, 0, $setting['limit']);

		foreach ($results as $result) {
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], $setting['image_width'], $setting['image_height']);
			} else {
				$image = false;
			}

			if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
				$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$price = false;
			}
					
			if ((float)$result['special']) { 
				$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$special = false;
			}
			
			if ($this->config->get('config_review_status')) {
				$rating = $result['rating'];
			} else {
				$rating = false;
			}
			

			/* start - ipl extension - dbassa */
			
			$mylabels = new Label($this->registry);

			$mylabels->labels = $config_labels;
			$mylabels->product_info = $result;
			$mylabels->current_layout = $current_layout;
			$mylabels->current_layout_position = $setting['position'];
			$mylabels->products_featured = $products_featured;
			$mylabels->bestsellers = $bestsellers;
			$labels = $mylabels->RenderLabels();

			/* end - ipl extension - dbassa */
			
			$this->data['special_products'][] = array(

			/* start - ipl extension - dbassa */

			'labels' => $labels,

			/* end - ipl extension - dbassa */
			
				'product_id' => $result['product_id'],
				'thumb'   	 => $image,
				'name'        => substr($result['name'], 0, 85) . '',
				'price'   	 => $price,
				'special' 	 => $special,
				'rating'     => $rating,
				'quantity' => $result['quantity'],
				'tarih'         => $result['date_added'], 
				'reviews'    => sprintf($this->language->get('text_reviews'), (int)$result['reviews']),
				'href'    	 => $this->url->link('product/product', 'product_id=' . $result['product_id']),
			);
		}
		//

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/featuredtabs.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/featuredtabs.tpl';
		} else {
			$this->template = 'default/template/module/featuredtabs.tpl';
		}

		$this->render();
	}
}
?>