<?php
class NitroDb {
	public static $singleton;
	private $link = false;
	
	public static function getInstance() {
		if (empty(self::$singleton)) self::$singleton = new NitroDb();
		return self::$singleton->getLink();
	}
	
	public function __construct() {
        $this->link = new NitroDBClass(DB_DRIVER, DB_HOSTNAME, DB_USERNAME, DB_PASSWORD, DB_DATABASE);
	}
	
	public function getLink() { return $this->link; }
}

class NitroDBClass {
    private $driver;

    public function __construct($driver, $hostname, $username, $password, $database) {
        $file = DIR_DATABASE . $driver . '.php';

        if (file_exists($file)) {
            require_once($file);

            if (VERSION >= '1.5.6.1') {
                $class = 'DB' . $driver;
            } else {
                $class = $driver;
            }

            $this->driver = new $class($hostname, $username, $password, $database);
        } else {
            exit('Error: Could not load database driver type ' . $driver . '!');
        }
    }

    public function query($sql) {
        return $this->driver->query($sql);
    }

    public function escape($value) {
        return $this->driver->escape($value);
    }

    public function countAffected() {
        return $this->driver->countAffected();
    }

    public function getLastId() {
        return $this->driver->getLastId();
    }
}