<?php
class ControllerModuleLatest extends Controller {
	protected function index($setting) {
		$this->language->load('module/latest');
		
      	$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['button_cart'] = $this->language->get('button_cart');
		
		$this->data['button_wishlist'] = $this->language->get('button_wishlist');
		
		$this->data['button_compare'] = $this->language->get('button_compare');
				
		$this->load->model('catalog/product');
/* start - ipl extension - dbassa */

			// bestseller
			
			$bestseller_products = $this->model_catalog_product->getBestSellerProducts(25);
			$bestsellers = array();
			
			foreach ($bestseller_products as $bestseller_product) {
				$bestsellers[] = $bestseller_product['product_id'];
			}
			
			// featured

			$products_featured = explode(',', $this->config->get('featured_product'));

			// labels config

			$config_labels = $this->config->get('intelligent_product_labels_module');
			if ( empty($config_labels) ) { $config_labels = array(); }

			// current class name

			$current_layout = get_class($this);

			/* end - ipl extension - dbassa */
		
		$this->load->model('tool/image');
		
		$this->data['products'] = array();
		
		$data = array(
			'sort'  => 'p.date_added',
			'order' => 'DESC',
			'start' => 0,
			'limit' => $setting['limit']
		);

		$results = $this->model_catalog_product->getProducts($data);

		foreach ($results as $result) {
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], $setting['image_width'], $setting['image_height']);
			} else {
				$image = false;
			}
			
			//this for swap image
				
				$images = $this->model_catalog_product->getProductImages($result['product_id']);

            if(isset($images[0]['image']) && !empty($images[0]['image'])){
                  $images =$images[0]['image'];
               } 
			   
				//
						
			if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
				$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$price = false;
			}
					
			if ((float)$result['special']) {
				$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$special = false;
			}
			
			if ($this->config->get('config_review_status')) {
				$rating = $result['rating'];
			} else {
				$rating = false;
			}
			

			/* start - ipl extension - dbassa */
			
			$mylabels = new Label($this->registry);

			$mylabels->labels = $config_labels;
			$mylabels->product_info = stripos($current_layout,'ControllerModuleFeatured') !== false || 
									  stripos($current_layout,'ControllerModuleFakelatest') !== false || 
									  stripos($current_layout,'ControllerModuleFakemostviewed') !== false || 
									  stripos($current_layout,'ControllerModuleFakebestseller')!== false ||
									  stripos($current_layout,'ControllerModulePreorders')!== false ? $product_info : $result;
			$mylabels->current_layout = $current_layout;
			$mylabels->current_layout_position = $setting['position'];
			$mylabels->products_featured = $products_featured;
			$mylabels->bestsellers = $bestsellers;
			$labels = $mylabels->RenderLabels();

			/* end - ipl extension - dbassa */
			
			$this->data['products'][] = array(

			/* start - ipl extension - dbassa */

			'labels' => $labels,

			/* end - ipl extension - dbassa */
			
				'product_id' => $result['product_id'],
				'thumb'   	 => $image,
				'name'    	 => $result['name'],
				'price'   	 => $price,
				'special' 	 => $special,
				'saving' => round((($result['price'] - $result['special'])/$result['price'])*100, 0),
				'rating'     => $rating,
				'reviews'    => sprintf($this->language->get('text_reviews'), (int)$result['reviews']),
				'href'    	 => $this->url->link('product/product', 'product_id=' . $result['product_id']),
				// for swap image
				'thumb_swap'  => $this->model_tool_image->resize($images, $this->config->get('config_image_product_width'), $this->config->get('config_image_product_height')), 
				//
				// for saving percentage
				'saving'	=> round((($result['price'] - $result['special'])/$result['price'])*100, 0),
				//
			);
		}

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/latest.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/latest.tpl';
		} else {
			$this->template = 'default/template/module/latest.tpl';
		}

		$this->render();
	}
}
?>