<?php
//    Copyright [2011] [iPara Bilgi Teknolojileri]
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.
//
//    @author erhan.asikoglu@ipara.com
//
// 
 
class ControllerPaymentIPara extends Controller {
	private $error = array(); 

	public function index() {
		$this->load->language('payment/ipara');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/setting');
			
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('ipara', $this->request->post);				
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_all_zones'] = $this->language->get('text_all_zones');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
						
		$this->data['entry_public_key'] = $this->language->get('entry_public_key');
		$this->data['entry_private_key'] = $this->language->get('entry_private_key');
		$this->data['entry_test'] = $this->language->get('entry_test'); 
		$this->data['entry_completed_status'] = $this->language->get('entry_completed_status'); 
		$this->data['entry_failed_status'] = $this->language->get('entry_failed_status');
		$this->data['entry_pending_status'] = $this->language->get('entry_pending_status');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['public_key'])) {
			$this->data['error_public_key'] = $this->error['public_key'];
		} else {
			$this->data['error_public_key'] = '';
		}
		
		if (isset($this->error['private_key'])) {
			$this->data['error_private_key'] = $this->error['private_key'];
		} else {
			$this->data['error_private_key'] = '';
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_payment'),
			'href'      => $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('payment/ipara', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
				
		$this->data['action'] = $this->url->link('payment/ipara', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['cancel'] = $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL');
		
		if (isset($this->request->post['ipara_public_key'])) {
			$this->data['ipara_public_key'] = $this->request->post['ipara_public_key'];
		} else {
			$this->data['ipara_public_key'] = $this->config->get('ipara_public_key');
		}
		
		if (isset($this->request->post['ipara_private_key'])) {
			$this->data['ipara_private_key'] = $this->request->post['ipara_private_key'];
		} else {
			$this->data['ipara_private_key'] = $this->config->get('ipara_private_key');
		}
		
		 
				
		if (isset($this->request->post['ipara_test'])) {
			$this->data['ipara_test'] = $this->request->post['ipara_test'];
		} else {
			$this->data['ipara_test'] = $this->config->get('ipara_test');
		}
				
		if (isset($this->request->post['ipara_completed_status_id'])) {
			$this->data['ipara_completed_status_id'] = $this->request->post['ipara_completed_status_id'];
		} else {
			$this->data['ipara_completed_status_id'] = $this->config->get('ipara_completed_status_id');
		}	
		 
		if (isset($this->request->post['ipara_failed_status_id'])) {
			$this->data['ipara_failed_status_id'] = $this->request->post['ipara_failed_status_id'];
		} else {
			$this->data['ipara_failed_status_id'] = $this->config->get('ipara_failed_status_id');
		}	
								
		if (isset($this->request->post['ipara_pending_status_id'])) {
			$this->data['ipara_pending_status_id'] = $this->request->post['ipara_pending_status_id'];
		} else {
			$this->data['ipara_pending_status_id'] = $this->config->get('ipara_pending_status_id');
		}
		
		$this->load->model('localisation/order_status');
		
		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['ipara_geo_zone_id'])) {
			$this->data['ipara_geo_zone_id'] = $this->request->post['ipara_geo_zone_id'];
		} else {
			$this->data['ipara_geo_zone_id'] = $this->config->get('ipara_geo_zone_id'); 
		} 
		
		$this->load->model('localisation/geo_zone');
										
		$this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();
		
		if (isset($this->request->post['ipara_status'])) {
			$this->data['ipara_status'] = $this->request->post['ipara_status'];
		} else {
			$this->data['ipara_status'] = $this->config->get('ipara_status');
		}
		
		if (isset($this->request->post['ipara_sort_order'])) {
			$this->data['ipara_sort_order'] = $this->request->post['ipara_sort_order'];
		} else {
			$this->data['ipara_sort_order'] = $this->config->get('ipara_sort_order');
		}

		$this->template = 'payment/ipara.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'payment/ipara')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!$this->request->post['ipara_public_key']) {
			$this->error['public_key'] = $this->language->get('error_public_key');
		}
		
		if (!$this->request->post['ipara_private_key']) {
			$this->error['private_key'] = $this->language->get('error_private_key');
		}
						
		if (!$this->error) {
			return true;
		} else {
			return false;
		}	
	}
}
?>
