<?php
//    Copyright [2011] [iPara Bilgi Teknolojileri]
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.
//
//    @author erhan.asikoglu@ipara.com
//
// 

class ModelPaymentIPara extends Model {
  	public function getMethod($address, $total) {
		$this->load->language('payment/ipara');
	
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('ipara_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");
		
		if (!$this->config->get('ipara_geo_zone_id')) {
			$status = true;
		} elseif ($query->num_rows) {
			$status = true;
		} else {
			$status = false;
		}

		$currencies = array( 
			'TRY'
		);
		
		if (!in_array(strtoupper($this->currency->getCode()), $currencies)) {
			$status = false;
		}
					
		$method_data = array();
	
		if ($status) {  
      		$method_data = array( 
        		'code'       => 'ipara',
        		'title'      => $this->language->get('text_title'),
				'sort_order' => $this->config->get('ipara_sort_order')
      		);
    	}
   
    	return $method_data;
  	}
}
?>
