<?php
//    Copyright [2011] [iPara Bilgi Teknolojileri]
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.
//
//    @author erhan.asikoglu@ipara.com
//
// 

class ControllerPaymentIPara extends Controller {
	protected function index() {
		$this->language->load('payment/ipara');
		
		$this->data['text_testmode'] = $this->language->get('text_testmode');		
    	
		$this->data['button_confirm'] = $this->language->get('button_confirm');

		$this->data['testmode'] = $this->config->get('ipara_test');
		
		if (!$this->config->get('ipara_test')) {
    		$this->data['action'] = 'https://www.ipara.com/odeme';
  		} else {
			$this->data['action'] = 'https://entegrasyon.ipara.com/sandbox';
		}

		$this->load->model('checkout/order');

		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

		if ($order_info) {
			$this->data['private_key'] = $this->config->get('ipara_private_key');
			$this->data['public_key'] = $this->config->get('ipara_public_key');
			
			 
			
			$this->data['item_name'] = html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8');				
			
			$this->data['products'] = array();
			
			$totalPrice = 0;
			foreach ($this->cart->getProducts() as $product) {
				 
				 
				$itemType = 2;
				if($product['shipping'] == 1){
					$itemType = 1;	
				}
				 
				$itemTax = $this->tax->calculate($product['price'], $product['tax_class_id'], $this->config->get('config_tax'));
				
				$price  =  floatval($itemTax)*$product['quantity'];
				
				$this->data['products'][] = array(
					'title'     	=> html_entity_decode($product['name'],ENT_QUOTES,'UTF-8'),
					'itemId'   		=> $product['product_id'],
					'price'    		=> $this->currency->format($price, $order_info['currency_code'], false, false),
					'itemCount' 	=> $product['quantity'],
					'itemType' 		=> $itemType,
					'shippingInfo'	=> html_entity_decode($order_info['shipping_address_1'], ENT_QUOTES, 'UTF-8') . " "  . html_entity_decode($order_info['shipping_address_2'], ENT_QUOTES, 'UTF-8'),
				
				);
				
				$totalPrice += $price; 
			 
				
			}	
			
			$this->data['discount_amount_cart'] = 0;
			
			$total = $this->currency->format($order_info['total'] - $totalPrice, $order_info['currency_code'], false, false);
			if ($total > 0) {//extra service
				$this->data['extraServices'][] = array(
				
					'title'     => $this->language->get('text_cargo'), 
					'price'    => $total
				
				);
				//order
				$this->data["order"] = array( 'merchantOrderId' => $order_info['order_id'],
										   'totalPrice' => $this->currency->format($order_info['total'], $order_info['currency_code'], false, false),
										   'orderItems' => $this->data['products'],
										   'extraServices' => $this->data['extraServices']
										   );
			} else {
				$this->data['discount_amount_cart'] -= $total;
				//order
				$this->data["order"] = array( 'merchantOrderId' => $order_info['order_id'],
										   'totalPrice' => $this->currency->format($order_info['total'], $order_info['currency_code'], false, false),
										   'orderItems' => $this->data['products']
										   );
			}
			
			
			
			$this->data["purchaser"] = array( 'name' 	=>  html_entity_decode($order_info['payment_firstname'], ENT_QUOTES, 'UTF-8'),
											  'surname' => html_entity_decode($order_info['payment_lastname'], ENT_QUOTES, 'UTF-8'),
										      'email' 	=> $order_info['email'],
											  'gsm' 	=> $order_info['telephone'],
											  'address' => html_entity_decode($order_info['payment_address_1'], ENT_QUOTES, 'UTF-8') . " "  . html_entity_decode($order_info['payment_address_2'], ENT_QUOTES, 'UTF-8'),
											  'city' 	=> html_entity_decode($order_info['payment_zone'], ENT_QUOTES, 'UTF-8')
											  );
			//token generation
			$successUrl = $this->url->link('payment/ipara/callback', '', 'SSL');
			$failureUrl = $this->url->link('payment/ipara/callback', '', 'SSL');
			$text = $this->data['public_key'] . $this->data['private_key'] . $order_info['order_id'] . $this->currency->format($order_info['total'], $order_info['currency_code'], false, false) . $successUrl . $failureUrl; 
			$token = $this->prapareToken($text);
			$returnUrl = $this->url->link('checkout/checkout', '', 'SSL');
			
			$this->data['merchant'] = array ( 'vendorId'	=> 7,
											  'successUrl'	=> $successUrl,
											  'failureUrl'  => $failureUrl,
											  'token'		=> $token,
											  'publicKey'	=> $this->data['public_key'],
											  'returnUrl'	=> $returnUrl
											  );
										   
			$this->data["jsonOut"] = array ('order' 	=> $this->data["order"],
											'purchaser' => $this->data["purchaser"],
											'merchant' => $this->data["merchant"],
											);
											
			$this->data["paymentInfo"] = json_encode($this->data["jsonOut"]); 
		
			$this->data["paymentInfo"] = str_replace("\/","/",$this->data["paymentInfo"]);
			
			
		
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/ipara.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/payment/ipara.tpl';
			} else {
				$this->template = 'default/template/payment/ipara.tpl';
			}
	
			$this->render();
		}
	}
	
	private function prapareToken($text) {
		
		$token = base64_encode(sha1($text,true));
		return $token;
	
	}
	
	public function callback() {
	
		$this->load->language('payment/ipara'); 
		$res = "iparaResponse";
		  
		foreach ($this->request->post as $key => $value) {
			 
			if(strcmp($key,$res)== 0){
				 
				$data =  html_entity_decode($value, ENT_QUOTES, 'UTF-8');
				$data =  html_entity_decode($data, ENT_QUOTES, 'UTF-8');
				break;
			}
		} 
		 
		$response  =   json_decode($data);
		if (isset($response->merchantOrderId)) {
			$order_id = $response->merchantOrderId;
		} else {
			$order_id = 0;
		}
		
		$private_key = $this->config->get('ipara_private_key');
		$public_key = $this->config->get('ipara_public_key');
		 
		$text = $public_key.$private_key.$order_id;
		$token = $this->prapareToken($text);
		
		 
		$error = '';
		$order_status_id = $this->config->get('config_order_status_id');
		$paymentSuccess = false;
		if(strcmp($token,$response->token)== 0){
		 
			$this->load->model('checkout/order');
				
			$order_info = $this->model_checkout_order->getOrder($order_id);
		
			if ($order_info) {
				
				 
				if(isset($response->result)){
				
					if(intval($response->result) == 1){ //payment is successful.
						if($response->statusCode == 1) { //completed
							$order_status_id = $this->config->get('ipara_completed_status_id');
						}else if($response->statusCode == 2) {//pending
							$order_status_id = $this->config->get('ipara_pending_status_id');
						}
						$paymentSuccess = true;
					}else if(intval($response->result) == 0){//payment is not successful.
						$order_status_id = $this->config->get('ipara_failed_status_id');
						$error = $this->language->get('text_declined');
						
					} else {
						$order_status_id = $this->config->get('ipara_failed_status_id');
						$error = $this->language->get('text_failed');
					}
				}else {
					$order_status_id = $this->config->get('ipara_failed_status_id');
					$error = $this->language->get('text_failed');
				}
			} else {
				$order_status_id = $this->config->get('ipara_failed_status_id');
				$error = $this->language->get('text_unable');
			}	
				
		} else {
			$order_status_id = $this->config->get('ipara_failed_status_id');
			$error = $this->language->get('text_unable');
		}
			
		if ($error) {
			$this->data['breadcrumbs'] = array();

			$this->data['breadcrumbs'][] = array(
				'href'      => $this->url->link('common/home'),
				'text'      => $this->language->get('text_home'),
				'separator' => false
			);

			$this->data['breadcrumbs'][] = array(
				'href'      => $this->url->link('checkout/cart'),
				'text'      => $this->language->get('text_basket'),
				'separator' => $this->language->get('text_separator')
			);

			$this->data['breadcrumbs'][] = array(
				'href'      => $this->url->link('checkout/checkout', '', 'SSL'),
				'text'      => $this->language->get('text_checkout'),
				'separator' => $this->language->get('text_separator')
			);

			$this->data['breadcrumbs'][] = array(
				'href'      => $this->url->link('checkout/success'),
				'text'      => $this->language->get('text_failed'),
				'separator' => $this->language->get('text_separator')
			);
						
			$this->data['heading_title'] = $this->language->get('text_failed');

			$this->data['text_message'] = sprintf($this->language->get('text_failed_message'), $error, $this->url->link('information/contact'));
			
			$this->data['button_continue'] = $this->language->get('button_continue');
			
			$this->data['continue'] = $this->url->link('common/home');
			
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/success.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/common/success.tpl';
			} else {
				$this->template = 'default/template/common/success.tpl';
			}
			
			$this->children = array(
				'common/column_left',
				'common/column_right',
				'common/content_top',
				'common/content_bottom',
				'common/footer',
				'common/header'
			);
			
			$this->response->setOutput($this->render());
		} else if(!$error  && $paymentSuccess) {
			if (!$order_info['order_status_id']) {
					$this->model_checkout_order->confirm($order_id, $order_status_id);
				} else {
					$this->model_checkout_order->update($order_id, $order_status_id);
				}
			
			$this->redirect($this->url->link('checkout/success'));			
		}
        		
	
			
	}
}
?>