nitro.register('smusher', (function($){
	var token = '';
	var images = [];
	var imagesCount = 0;
	var progressIndex = 0;
	var flagPause = false;
	var logArea = null;
	var isLoadingImagesList = false;
	var isSmushWaiting = false;
	var isSmushStartEventFired = false;
	var smushFinishedCallbacks = [];
	var smushPausedCallbacks = [];
	var smushResumedCallbacks = [];
	var smushStartedCallbacks = [];
	var smushRestoredStateCallbacks = [];
	var smushStartedCallbacks = [];
	var smushCountChangeCallbacks = [];
	
	var getImageList = function() {
		progressIndex = 0;
		isLoadingImagesList = true;
		var smushTargetPath = '';
		if ($('#smushTargetPath').val().length > 0) {
			smushTargetPath = '&targetDir=' + $('#smushTargetPath').val().replace(/\//g, '%2F');
		}
		$.ajax({
			url: 'index.php?route=tool/nitro/getsmushimages'+smushTargetPath+'&token='+token,
			dataType: 'json',
			cache: false,
			success: function(data) {
				images = data;
				isLoadingImagesList = false;
				if (isSmushWaiting) {
					smush();
				}
			}
		});
	}
	
	var fireCallbacks = function(callbacksList) {
		if (callbacksList.length) {
			var callback = null;
			for (x=0; x<callbacksList.length;x++) {
				callback = callbacksList[x];
				callback();
			}
		}
	}
	
	var smush = function() {
		if (images.length > 0 && !isLoadingImagesList) {
			isSmushWaiting = false;
			if (typeof images[progressIndex] != 'undefined' && !flagPause) {
				if (!isSmushStartEventFired) {
					isSmushStartEventFired = true;
					fireCallbacks(smushStartedCallbacks);
				}
				
				$.ajax({
					url: 'index.php?route=tool/nitro/smushimagelist&token=' + token,
					type: 'POST',
					dataType: 'json',
					data: {imageList: [images[progressIndex]]},
					cache: false,
					success: function(data) {
						var extra_html = '';
						for (x in data.smushed_files) {
							extra_html += data.smushed_files[x].filename + ' <b>(' + data.smushed_files[x].percent + '% saved)</b><br><br>';
						}
						logArea.parent().show();
						var entries = logArea.html().split('<br><br>');
						if (entries.length >= 10) {
							entries.splice(0, 1);
							logArea.html(entries.join('<br><br>'));
						}
						logArea.append(extra_html).slideDown();
						$('.smush-log').css({width: $('.empty-smush-div').width() + 'px'}).animate({
							scrollTop: logArea.outerHeight()
						}, 1000);
						$('#smushedNumber').html(data.smushed_images_count);
						$('#alreadySmushedNumber').html(data.already_smushed_images_count);
						$('#kbSaved').html(data.kb_saved);
						$('#totalImages').html(data.total_images);
						$('#lastSmushTimestamp').html(formatTimestamp(data.last_smush_timestamp));
						
						progressIndex++;
						fireCallbacks(smushCountChangeCallbacks);
						smush();
					}
				});
			} else {
				saveState();
				if (typeof images[progressIndex] == 'undefined') {
					fireCallbacks(smushFinishedCallbacks);
				} else if (flagPause) {
					fireCallbacks(smushPausedCallbacks);
				}
			}
		} else if(isLoadingImagesList) {
			isSmushWaiting = true;
		}
	}
	
	var stopSmushing = function() {
		flagPause = true;
	}
	
	var saveState = function() {
		if(typeof(Storage)!=="undefined") {
			localStorage.nitroSmusherImages = JSON.stringify(images);
			localStorage.nitroSmusherProgressIndex = progressIndex;
		} else {
			console.log('Smusher: localStoreage API not available!');
		}
	}
	
	var validateSavedState = function() {
		return (typeof(localStorage.nitroSmusherImages) != 'undefined' && typeof(localStorage.nitroSmusherProgressIndex) != 'undefined');
	}
	
	var restoreState = function() {
		if(typeof(Storage)!=="undefined" && validateSavedState()) {
			images = JSON.parse(localStorage.nitroSmusherImages);
			progressIndex = parseInt(localStorage.nitroSmusherProgressIndex);
			fireCallbacks(smushRestoredStateCallbacks);
			return true;
		} else {
			return false;
		}
	}
	
	var clearSavedState = function() {
		if(typeof(Storage)!=="undefined" && validateSavedState()) {
			localStorage.removeItem('nitroSmusherImages');
			localStorage.removeItem('nitroSmusherProgressIndex');
		} else {
			return true;
		}
	}
	
	return {
		init: function(logElement, getNewImageList) {
			getNewImageList = getNewImageList ? true : false;
			
			logArea = logElement;
			if (!restoreState() && getNewImageList) {
				getImageList();
			}
		},
		reset: function() {
			images = [];
			imagesCount = 0;
			progressIndex = 0;
			flagPause = false;
			isSmushStartEventFired = false;
			clearSavedState();
			logArea.html('');
		},
		begin: function(){
			progressIndex = 0;
			flagPause = false;
			isSmushStartEventFired = false;
			smush();
		},
		restart: function() {
			images = [];
			imagesCount = 0;
			progressIndex = 0;
			flagPause = false;
			isSmushStartEventFired = false;
			logArea.html('');
			getImageList();
			smush();
		},
		resume: function(){
			flagPause = false;
			isSmushStartEventFired = false;
			smush();
		},
		pause: function(){
			stopSmushing();
		},
		setToken: function(t) {
			token = t;
		},
		getImages: function() { return images; },
		getTotalImagesCount: function() {
			if (imagesCount == 0) {
				imagesCount = images.length;
			}
			
			return imagesCount;
		},
		getProcessedImagesCount: function() {
			return progressIndex;
		},
		addSmushFinishEventListener: function(callback) {
			if (typeof callback === 'function') {
				smushFinishedCallbacks.push(callback);
			}
		},
		addSmushPauseEventListener: function(callback) {
			if (typeof callback === 'function') {
				smushPausedCallbacks.push(callback);
			}
		},
		addSmushResumeEventListener: function(callback) {
			if (typeof callback === 'function') {
				smushResumedCallbacks.push(callback);
			}
		},
		addSmushStartEventListener: function(callback) {
			if (typeof callback === 'function') {
				smushStartedCallbacks.push(callback);
			}
		},
		addSmushRestoredStateEventListener: function(callback) {
			if (typeof callback === 'function') {
				smushRestoredStateCallbacks.push(callback);
			}
		},
		addSmushStartedEventListener: function(callback) {
			if (typeof callback === 'function') {
				smushStartedCallbacks.push(callback);
			}
		},
		addSmushCountChangedEventListener: function(callback) {
			if (typeof callback === 'function') {
				smushCountChangeCallbacks.push(callback);
			}
		}
	};
})(jQuery));