<?php
class ControllerTotalPaymentFee extends Controller { 
	private $error = array(); 
	 
	public function index() {
		$this->load->language('total/payment_fee');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/setting');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			if (isset($this->request->post['payment_fee'])) {
				$this->request->post['payment_fee'] = serialize($this->request->post['payment_fee']);
			}
			$this->model_setting_setting->editSetting('payment_fee', $this->request->post);
		
			$this->session->data['success'] = $this->language->get('text_success');

            $this->redirect($this->url->link('extension/total', 'token=' . $this->session->data['token'], 'SSL'));
		}
		
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_none'] = $this->language->get('text_none');
        $this->data['text_fee'] = $this->language->get('text_fee');
        $this->data['text_discount'] = $this->language->get('text_discount');
		$this->data['text_all_zones'] = $this->language->get('text_all_zones');
		$this->data['text_select'] = $this->language->get('text_select');
		$this->data['text_help_payment'] = $this->language->get('text_help_payment');
		$this->data['text_help_fixe_amount'] = $this->language->get('text_help_fixe_amount');
		$this->data['text_help_percentage'] = $this->language->get('text_help_percentage');
		$this->data['text_help_total'] = $this->language->get('text_help_total');
        $this->data['text_help_type'] = $this->language->get('text_help_type');

		$this->data['entry_total'] = $this->language->get('entry_total');
		$this->data['entry_fee'] = $this->language->get('entry_fee');
        $this->data['entry_type'] = $this->language->get('entry_type');
        $this->data['entry_tax'] = $this->language->get('entry_tax');
		$this->data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$this->data['entry_payment'] = $this->language->get('entry_payment');
		$this->data['entry_fee_p'] = $this->language->get('entry_fee_p');
		$this->data['entry_fee_f'] = $this->language->get('entry_fee_f');
					
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['button_remove'] = $this->language->get('button_remove');
		$this->data['button_add_payment_fee'] = $this->language->get('button_add_payment_fee');
 
		$this->data['tab_general'] = $this->language->get('tab_general');
		$this->data['tab_payment_type'] = $this->language->get('tab_payment_type');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

   		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_total'),
			'href'      => $this->url->link('extension/total', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('total/payment_fee', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);

		$this->data['action'] = $this->url->link('total/payment_fee', 'token=' . $this->session->data['token'], 'SSL');

		$this->data['cancel'] = $this->url->link('extension/total', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->post['payment_fee_status'])) {
			$this->data['payment_fee_status'] = $this->request->post['payment_fee_status'];
		} else {
			$this->data['payment_fee_status'] = $this->config->get('payment_fee_status');
		}

		if (isset($this->request->post['payment_fee_sort_order'])) {
			$this->data['payment_fee_sort_order'] = $this->request->post['payment_fee_sort_order'];
		} else {
			$this->data['payment_fee_sort_order'] = $this->config->get('payment_fee_sort_order');
		}

		if (isset($this->request->post['payment_fee_geo_zone_id'])) {
			$this->data['payment_fee_geo_zone_id'] = $this->request->post['payment_fee_geo_zone_id'];
		} else {
			$this->data['payment_fee_geo_zone_id'] = $this->config->get('payment_fee_geo_zone_id');
		}

		$this->load->model('localisation/geo_zone');

		$this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		if (isset($this->request->post['payment_fee_tax_class_id'])) {
			$this->data['payment_fee_tax_class_id'] = $this->request->post['payment_fee_tax_class_id'];
		} else {
			$this->data['payment_fee_tax_class_id'] = $this->config->get('payment_fee_tax_class_id');
		}

		$this->load->model('localisation/tax_class');

		$this->data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();

		$this->load->model('setting/extension');

		$payments = $this->model_setting_extension->getInstalled('payment');
						
		$files = glob(DIR_APPLICATION . 'controller/payment/*.php');
		
		if ($files) {
			foreach ($files as $file) {
				$payment = basename($file, '.php');
				
				$this->load->language('payment/' . $payment);
				
				if (in_array($payment, $payments)) {
					$this->data['payments'][] = array(
						'name'       => $this->language->get('heading_title'),
						'payment_id' => $payment
					);
				}
			}
		}

		$payment_fee_info = unserialize($this->config->get('payment_fee'));
		
		if (isset($this->request->post['payment_fee'])) {
			$this->data['payment_fees'] = $this->request->post['payment_fee'];
		} elseif (isset($payment_fee_info)) {
			$this->data['payment_fees'] = $payment_fee_info;
		} else { 
			$this->data['payment_fees'] = array();
		}
		
		$this->template = 'total/payment_fee.tpl';
		$this->children = array(
			'common/header',
			'common/footer'	
		);
		
		$this->response->setOutput($this->render());
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'total/payment_fee')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
    	if (!$this->error) {
			return TRUE;
    	} else {
			if (!isset($this->error['warning'])) {
				$this->error['warning'] = $this->language->get('error_required_data');
			}
      		return FALSE;
    	}	
	}
}
?>