<?php
class ControllerPaymentPayU extends Controller {
	private $error = array(); 

	public function index() {
		$this->load->language('payment/payu');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/setting');
			
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('payu', $this->request->post);				
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_all_zones'] = $this->language->get('text_all_zones');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
						
		$this->data['entry_magazaadi'] = $this->language->get('entry_magazaadi');
		$this->data['entry_anahtar'] = $this->language->get('entry_anahtar');
		$this->data['entry_taksit'] = $this->language->get('entry_taksit');
		$this->data['entry_taksit_ornek'] = $this->language->get('entry_taksit_ornek'); 
		$this->data['entry_completed_status'] = $this->language->get('entry_completed_status'); 
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['magazaadi'])) {
			$this->data['error_magazaadi'] = $this->error['magazaadi'];
		} else {
			$this->data['error_magazaadi'] = '';
		}
		
		if (isset($this->error['anahtar'])) {
			$this->data['error_anahtar'] = $this->error['anahtar'];
		} else {
			$this->data['error_anahtar'] = '';
		}

		if (isset($this->error['taksit'])) {
			$this->data['error_taksit'] = $this->error['taksit'];
		} else {
			$this->data['error_taksit'] = '';
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_payment'),
			'href'      => $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('payment/payu', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
				
		$this->data['action'] = $this->url->link('payment/payu', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['cancel'] = $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL');
		
		if (isset($this->request->post['payu_magazaadi'])) {
			$this->data['payu_magazaadi'] = $this->request->post['payu_magazaadi'];
		} else {
			$this->data['payu_magazaadi'] = $this->config->get('payu_magazaadi');
		}
		
		if (isset($this->request->post['payu_anahtar'])) {
			$this->data['payu_anahtar'] = $this->request->post['payu_anahtar'];
		} else {
			$this->data['payu_anahtar'] = $this->config->get('payu_anahtar');
		}

		if (isset($this->request->post['payu_taksit'])) {
			$this->data['payu_taksit'] = $this->request->post['payu_taksit'];
		} else {
			$this->data['payu_taksit'] = $this->config->get('payu_taksit');
		}
		
		 
				
		if (isset($this->request->post['payu_completed_status_id'])) {
			$this->data['payu_completed_status_id'] = $this->request->post['payu_completed_status_id'];
		} else {
			$this->data['payu_completed_status_id'] = $this->config->get('payu_completed_status_id');
		}	
		
		$this->load->model('localisation/order_status');
		
		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['payu_geo_zone_id'])) {
			$this->data['payu_geo_zone_id'] = $this->request->post['payu_geo_zone_id'];
		} else {
			$this->data['payu_geo_zone_id'] = $this->config->get('payu_geo_zone_id'); 
		} 
		
		$this->load->model('localisation/geo_zone');
										
		$this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();
		
		if (isset($this->request->post['payu_status'])) {
			$this->data['payu_status'] = $this->request->post['payu_status'];
		} else {
			$this->data['payu_status'] = $this->config->get('payu_status');
		}
		
		if (isset($this->request->post['payu_sort_order'])) {
			$this->data['payu_sort_order'] = $this->request->post['payu_sort_order'];
		} else {
			$this->data['payu_sort_order'] = $this->config->get('payu_sort_order');
		}

		$this->template = 'payment/payu.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'payment/payu')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!$this->request->post['payu_magazaadi']) {
			$this->error['magazaadi'] = $this->language->get('error_magazaadi');
		}
		
		if (!$this->request->post['payu_anahtar']) {
			$this->error['anahtar'] = $this->language->get('error_anahtar');
		}
			
		if (!$this->request->post['payu_taksit']) {
			$this->error['taksit'] = $this->language->get('error_taksit');
		}
					
		if (!$this->error) {
			return true;
		} else {
			return false;
		}	
	}
}
?>
