<?php
#############################################################################
   # version 1.1.0 
   # copyright Sunflowerbiz
   # contact : yolanda_txw@hotmail.com
#############################################################################
class ControllerModuleProductPaymentLimit extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('module/product_payment_limit');

		$this->document->setTitle( $this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->model_setting_setting->editSetting('product_payment_limit', $this->request->post);
			$this->model_setting_setting->editSetting('mix_cart_payment', $this->request->post);

			$this->model_setting_setting->editSetting('conflict_cart_payment', $this->request->post);
			
	if(!empty($this->request->post['force_payment_methods_array'])){
		$this->request->post['force_payment_methods'] = implode('|',$this->request->post['force_payment_methods_array']);
  	}else{
		$this->request->post['force_payment_methods'] = NULL;
	}
			
			$this->model_setting_setting->editSetting('force_payment_methods', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect((HTTPS_SERVER . 'index.php?route=extension/module&token=' . $this->session->data['token']));
		}
		
	global $db;
	$db->query("CREATE  TABLE IF NOT EXISTS `" . DB_PREFIX . "product_payment_limit` ( 
  				`product_payment_limit_id` int(11) NOT NULL auto_increment, 
  				`product_id` int( 11  )  NOT  NULL default  '0',
 				`product_payment_limit` text  NOT  NULL default  '' ,
 				PRIMARY KEY  (`product_payment_limit_id`)
 	)");
	
	
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['enable_product_payment_limit'] = $this->language->get('enable_product_payment_limit');
		$this->data['mix_cart_payment_method'] = $this->language->get('mix_cart_payment_method');
		$this->data['mix_cart_payment_method_2'] = $this->language->get('mix_cart_payment_method_2');
		$this->data['mix_cart_payment_method_1'] = $this->language->get('mix_cart_payment_method_1');

		$this->data['conflict_cart_payment_method'] = $this->language->get('conflict_cart_payment_method');
		$this->data['conflict_cart_payment_method_2'] = $this->language->get('conflict_cart_payment_method_2');
		$this->data['conflict_cart_payment_method_1'] = $this->language->get('conflict_cart_payment_method_1');
  	
		$this->data['force_payment_method'] = $this->language->get('force_payment_method');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		if (isset($this->error['warning']))
		{
			$this->data['error_warning'] = $this->error['warning'];
		}
		else
		{
			$this->data['error_warning'] = '';
		}
		if (isset($this->error['error_sort_order']))
		{
			$this->data['error_sort_order'] = $this->error['error_sort_order'];
		}
		else
		{
			$this->data['error_sort_order'] = '';
		}
		if (isset($this->error['error_limit']))
		{
			$this->data['error_limit'] = $this->error['error_limit'];
		}
		else
		{
			$this->data['error_limit'] = '';
		}

  		$this->document->breadcrumbs = array();

   		$this->document->breadcrumbs[] = array(
       		'href'      => (HTTPS_SERVER . 'index.php?route=common/home&token=' . $this->session->data['token']),
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => (HTTPS_SERVER . 'index.php?route=extension/module&token=' . $this->session->data['token']),
       		'text'      => $this->language->get('text_module'),
      		'separator' => ' :: '
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => (HTTPS_SERVER . 'index.php?route=module/product_payment_limit&token=' . $this->session->data['token']),
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);

		$this->data['action'] = (HTTPS_SERVER . 'index.php?route=module/product_payment_limit&token=' . $this->session->data['token']);

		$this->data['cancel'] = (HTTPS_SERVER . 'index.php?route=extension/module&token=' . $this->session->data['token']);

		if (isset($this->request->post['product_payment_limit'])) {
			$this->data['product_payment_limit'] = $this->request->post['product_payment_limit'];
		} else {
			$this->data['product_payment_limit'] = $this->config->get('product_payment_limit');
		}
		
		if (isset($this->request->post['mix_cart_payment'])) {
			$this->data['mix_cart_payment'] = $this->request->post['mix_cart_payment'];
		} else {
			$this->data['mix_cart_payment'] = $this->config->get('mix_cart_payment');
		}
		
		
		if (isset($this->request->post['conflict_cart_payment'])) {
			$this->data['conflict_cart_payment'] = $this->request->post['conflict_cart_payment'];
		} else {
			$this->data['conflict_cart_payment'] = $this->config->get('conflict_cart_payment');
		}
		
		if (isset($this->request->post['force_payment_methods'])) {
			$this->data['force_payment_methods'] = $this->request->post['force_payment_methods'];
		} else {
			$this->data['force_payment_methods'] = $this->config->get('force_payment_methods');
		}
		
		$this->id       = 'product_payment_limit';
		$this->template = 'module/product_payment_limit.tpl';
		$this->children = array(
			'common/header',	
			'common/footer'	
		);
		
		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));

 		$this->render();
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'module/product_payment_limit')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
	
		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
}
?>