<?php 
class ControllerFeedtoplufiyatkat extends Controller {
	private $error = array(); 
	
	public function index() {
		$this->language->load('feed/toplufiyatkat');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/setting');
			
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) 
		{
			$this->model_setting_setting->editSetting('toplufiyatkat', $this->request->post);				
			
			$this->session->data['success'] = $this->language->get('text_success');
		
			if (isset($this->request->post['product_category']))
			{
		
				$catids = '';
				$prodids = '';
				foreach($this->request->post['product_category']  as $cat_id)
				{
	      	 $catids = ($catids =='' ? '('.$cat_id :  $catids . ',' . $cat_id); 
				}
	  		$catids = $catids . ')';
				
 					
				$query = $this->db->query("SELECT  distinct (product_id) FROM " . DB_PREFIX . "product_to_category WHERE category_id in " . $catids);
 							
 						foreach ($query->rows as $result) 
 								{
 									$prodids = ($prodids =='' ? '('.$result['product_id'] :  $prodids . ',' . $result['product_id']); 
 								} 
 				if ($prodids == '')
 				{
 						$this->session->data['success'] = "No products selected";
 				}				
				else
				{
						$prodids = $prodids . ')';
					
						//empty if emptydiscount is selected		
						if (isset($this->request->post['toplufiyatkat_emptydiscount']))
						{
							$this->db->query("DELETE  FROM " . DB_PREFIX . "product_discount WHERE product_id in " .$prodids);
						}
						//empty if emptyspecialprice is selected
						if (isset($this->request->post['toplufiyatkat_emptyspecialprice']))
						{
							 $this->db->query("DELETE  FROM " . DB_PREFIX . "product_special WHERE product_id in " .$prodids);
						}
						
						//	
							$ppcgid = 1;
					
							if (isset($this->request->post['productpricer_customer_group_id']))
							{
									$ppcgid = $this->request->post['productpricer_customer_group_id'];
							}
						
						$datestart = "0000-00-00";
						$dateend = "0000-00-00";
						if (isset($this->request->post['product_discount_date_start']))
						{
							$datestart = $this->request->post['product_discount_date_start'];
						}
						if (isset($this->request->post['product_discount_date_end']))
						{
							$dateend =$this->request->post['product_discount_date_end'];
						}
						
						$product_id_data = array();
						$product_price = array();
					
						$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product WHERE product_id in " .$prodids);
					
						foreach ($query->rows as $result) 
						{
							$product_id_data[$result['product_id']] = $result['price'];
						}
						
								
						foreach($product_id_data as $product_id => $iPrice)
						{
					
							if ($this->request->post['toplufiyatkat_type'] == 'F')
							{
								$newPrice = $iPrice + $this->request->post['toplufiyatkat_amount'];
							}
							else
							{
								$tempPerc = 100 + $this->request->post['toplufiyatkat_amount'];
								$tempPerc = $tempPerc / 100;
							
								$newPrice = $iPrice * $tempPerc;
							}
						
							switch ($this->request->post['toplufiyatkat_discount']) 
							{
							case "D":    // is discount or price selected
							
							// create new discounts
							  if (isset($this->request->post['toplufiyatkat_quantity']))
							  {
							  	$quantity = $this->request->post['toplufiyatkat_quantity'];
							  }
							  else
							  {
							  	$quantity = 1;
							  }
							  
							 if ($this->request->post['toplufiyatkat_type'] == 'F')
								{
									$newPrice =  $this->request->post['toplufiyatkat_amount'];
								}
								else
								{
									$tempPerc = 100 + $this->request->post['toplufiyatkat_amount'];
									$tempPerc = $tempPerc / 100;
								
									$newPrice = $iPrice * $tempPerc;
								}
							  
								$this->db->query("INSERT INTO " . DB_PREFIX . "product_discount SET product_id = '" . (int)$product_id . "', customer_group_id = '". $ppcgid. "', quantity = '". (int)$quantity ."',  price = '" . (float)$newPrice . "', date_start ='".$datestart."', date_end ='".$dateend."'");
								break;
							case "S":   // is discount or price selected
							
							//create new special price	
							
							 if ($this->request->post['toplufiyatkat_type'] == 'F')
								{
									$newPrice =  $this->request->post['toplufiyatkat_amount'];
								}
								else
								{
									$tempPerc = 100 + $this->request->post['toplufiyatkat_amount'];
									$tempPerc = $tempPerc / 100;
								
									$newPrice = $iPrice * $tempPerc;
								}
							
							
					  		$this->db->query("INSERT INTO " . DB_PREFIX . "product_special SET product_id = '" . (int)$product_id . "', customer_group_id = '". $ppcgid. "', price = '" . (float)$newPrice . "', date_start ='".$datestart."', date_end ='".$dateend."'");
								break;
							case "F":
							
							// update current prices
							 $this->db->query("UPDATE " . DB_PREFIX . "product SET price = '" . $newPrice . "' WHERE product_id = '" . (int)$product_id . "'");
							 break;
							}  //switch
						}//foreach
						
						
						
							//toplufiyatkat_includeoption
						if (isset($this->request->post['toplufiyatkat_includeoption']))
						{
							$product_option_data = array();
							$option_price = array();
					
							$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_option_value WHERE product_id in " .$prodids);
					
							foreach ($query->rows as $result) 
							{
								$product_option_data[$result['product_option_value_id']] = $result['price'];
							}
							foreach($product_option_data as $product_id => $iPrice)
							{
					
								if ($this->request->post['toplufiyatkat_type'] == 'F')
								{
									$newPrice = $iPrice + $this->request->post['toplufiyatkat_amount'];
								}
								else
								{
									$tempPerc = 100 + $this->request->post['toplufiyatkat_amount'];
									$tempPerc = $tempPerc / 100;
							
									$newPrice = $iPrice * $tempPerc;
								}
								
							 $this->db->query("UPDATE " . DB_PREFIX . "product_option_value SET price = '" . $newPrice . "' WHERE product_option_value_id = '" . (int)$product_id . "'");
							
							}//foreach
						
						}//if includeoption checked
					
					
					
					
					
				}
			}
			
			//Clear cache
			
			 $this->data['clear_cache'] = $this->url->link('common/home','token=' . $this->session->data['token'].'&clear_cache=true','SSL');
        
       $iterator = new DirectoryIterator(DIR_CACHE);
       foreach($iterator as $file){
       if(!$file->isDot()){
            unlink($file->getPathname());
            }
       }
               
			
			
			
			
			
  		$this->redirect($this->url->link('extension/feed', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['entry_category'] = $this->language->get('entry_category');
		$this->data['text_select_all'] = $this->language->get('text_select_all');
		$this->data['text_unselect_all'] = $this->language->get('text_unselect_all');
		
		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_discount_special'] = $this->language->get('text_discount_special');
				
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_data_feed'] = $this->language->get('entry_data_feed');
		
		$this->data['entry_amount'] = $this->language->get('entry_amount');
		$this->data['entry_type'] = $this->language->get('entry_type');
		$this->data['entry_select'] = $this->language->get('entry_select');
		$this->data['entry_quantity'] = $this->language->get('entry_quantity');
		
		$this->data['entry_type_fixed'] = $this->language->get('entry_type_fixed');
    $this->data['entry_type_percentage'] = $this->language->get('entry_type_percentage');
    
    $this->data['entry_discount'] = $this->language->get('entry_discount');
    $this->data['entry_discount_discount'] = $this->language->get('entry_discount_discount');
    $this->data['entry_discount_price'] = $this->language->get('entry_discount_price');
    $this->data['entry_discount_special'] = $this->language->get('entry_discount_special');
	
	$this->data['entry_date_start'] = $this->language->get('entry_date_start');
    $this->data['entry_date_end'] = $this->language->get('entry_date_end');
  
    $this->data['entry_includeoption'] = $this->language->get('entry_includeoption');
    
    $this->data['entry_emptydiscount'] = $this->language->get('entry_emptydiscount');
    $this->data['entry_emptyspecialprice'] = $this->language->get('entry_emptyspecialprice');
		
		$this->data['entry_catagory'] = $this->language->get('entry_catagory');
		$this->data['entry_data_catagory'] = $this->language->get('entry_data_catagory');
		
		$this->data['entry_customer_group'] = $this->language->get('entry_customer_group');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_feed'),
			'href'      => $this->url->link('extension/feed', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('feed/toplufiyatkat', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
				
		$this->data['action'] = $this->url->link('feed/toplufiyatkat', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['cancel'] = $this->url->link('extension/feed', 'token=' . $this->session->data['token'], 'SSL');
		
		if (isset($this->request->post['toplufiyatkat_status'])) {
			$this->data['toplufiyatkat_status'] = $this->request->post['toplufiyatkat_status'];
		} else {
			$this->data['toplufiyatkat_status'] = $this->config->get('toplufiyatkat_status');
		}
		
		if (isset($this->request->post['toplufiyatkat_amount'])) {
			$this->data['toplufiyatkat_amount'] = $this->request->post['toplufiyatkat_amount'];
		} else {
			$this->data['toplufiyatkat_amount'] = $this->config->get('toplufiyatkat_amount');
		}

		if (isset($this->request->post['toplufiyatkat_type'])) {
			$this->data['toplufiyatkat_type'] = $this->request->post['toplufiyatkat_type'];
		} else {
			$this->data['toplufiyatkat_type'] = $this->config->get('toplufiyatkat_type');
		}
		
		if (isset($this->request->post['toplufiyatkat_discount'])) {
			$this->data['toplufiyatkat_discount'] = $this->request->post['toplufiyatkat_discount'];
		} else {
			$this->data['toplufiyatkat_discount'] = $this->config->get('toplufiyatkat_discount');
		}
		
		if (isset($this->request->post['product_category'])) {
			$this->data['product_category'] = $this->request->post['product_category'];
		}
		 else {
			$this->data['product_category'] = array();
		}		
		
		$this->load->model('sale/customer_group');
		
		$this->data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();
		
		$this->data['data_feed'] = HTTP_CATALOG . 'index.php?route=feed/toplufiyatkat';
		//$this->data['data_catagory'] = 'select your catagory';
		
		$this->load->model('catalog/category');
				
		$this->data['categories'] = $this->model_catalog_category->getCategories(0);

		$this->template = 'feed/toplufiyatkat.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	} 
	
	private function validate() {
		if (!$this->user->hasPermission('modify', 'feed/toplufiyatkat')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->error) {
			return true;
		} else {
		
	
		
		
			return false;
		}	
	}	
}
?>