<!DOCTYPE html>
<html dir="<?php echo $direction; ?>" lang="<?php echo $lang; ?>">
<head>
<meta charset="UTF-8" />
<title><?php echo $title; ?></title>
<base href="<?php echo $base; ?>" />
<meta name="viewport" content="target-densitydpi=device-dpi, width=device-width, initial-scale=1, maximum-scale=1,user-scalable=no" />
<?php if ($description) { ?>
<meta name="description" content="<?php echo $description; ?>" />
<?php } ?>
<?php if ($keywords) { ?>
<meta name="keywords" content="<?php echo $keywords; ?>" />
<?php } ?>
<?php if ($icon) { ?>
<link href="<?php echo $icon; ?>" rel="icon" />
<?php } ?>
<?php foreach ($links as $link) { ?>
<link href="<?php echo $link['href']; ?>" rel="<?php echo $link['rel']; ?>" />
<?php } ?>
<link rel="stylesheet" type="text/css" href="catalog/view/theme/marketing/stylesheet/stylesheet.css" />
<link rel="stylesheet" type="text/css" href="catalog/view/theme/default/stylesheet/cartconfirm.css">
 <link href='http://fonts.googleapis.com/css?family=Cuprum:400,700&subset=latin-ext' rel='stylesheet' type='text/css'>
<?php foreach ($styles as $style) { ?>
<link rel="<?php echo $style['rel']; ?>" type="text/css" href="<?php echo $style['href']; ?>" media="<?php echo $style['media']; ?>" />
<?php } ?>
<script type="text/javascript" src="catalog/view/javascript/jquery/jquery-1.7.1.min.js"></script>
<script type="text/javascript" src="catalog/view/javascript/jquery/ui/jquery-ui-1.8.16.custom.min.js"></script>
<link rel="stylesheet" type="text/css" href="catalog/view/javascript/jquery/ui/themes/ui-lightness/jquery-ui-1.8.16.custom.css" />
<script type="text/javascript" src="catalog/view/javascript/common2.js"></script>
<script type="text/javascript" src="catalog/view/theme/marketing/js/custom.js"></script>
<script type="text/javascript" src="catalog/view/theme/marketing/js/scrolltopcontrol.js"></script>
<script type="text/javascript" src="catalog/view/theme/marketing/js/jquery.carouFredSel-6.1.0-packed.js"></script>
<script type="text/javascript" src="catalog/view/javascript/jquery/jquery.jcarousel.min.js"></script>
<?php foreach ($scripts as $script) { ?>
<script type="text/javascript" src="<?php echo $script; ?>"></script>
<?php } ?>
<!--[if IE 7]> 
<link rel="stylesheet" type="text/css" href="catalog/view/theme/marketing/stylesheet/ie7.css" />
<![endif]-->
<!--[if lt IE 7]>
<link rel="stylesheet" type="text/css" href="catalog/view/theme/marketing/stylesheet/ie6.css" />
<script type="text/javascript" src="catalog/view/javascript/DD_belatedPNG_0.0.8a-min.js"></script>
<script type="text/javascript">
DD_belatedPNG.fix('#logo img');
</script>
<![endif]-->
<?php if ($stores) { ?>
<script type="text/javascript"><!--
$(document).ready(function() {
<?php foreach ($stores as $store) { ?>
$('body').prepend('<iframe src="<?php echo $store; ?>" style="display: none;"></iframe>');
<?php } ?>
});
//--></script>
<?php } ?>
<?php echo $google_analytics; ?>
</head>
<body>
<div id="opaclayer" onclick="closeCart();"></div>
<?php
$this->language->load('common/footer');
$text_contact = $this->language->get('text_contact');
$text_information = $this->language->get('text_information');

$text_service = $this->language->get('text_service');
$text_return = $this->language->get('text_return');
$text_sitemap = $this->language->get('text_sitemap');

$text_extra = $this->language->get('text_extra');
$text_manufacturer = $this->language->get('text_manufacturer');
$text_voucher = $this->language->get('text_voucher');
$text_affiliate = $this->language->get('text_affiliate');
$text_special = $this->language->get('text_special');

$text_order = $this->language->get('text_order');
$text_newsletter = $this->language->get('text_newsletter');

?>
<?php
$this->language->load('information/contact');
$text_location = $this->language->get('text_location');
$text_address = $this->language->get('text_address');
$text_telephone = $this->language->get('text_telephone');
$text_fax = $this->language->get('text_fax');
?>
<?php
$this->language->load('account/login');
$text_forgotten = $this->language->get('text_forgotten');
$text_register = $this->language->get('text_register');
$entry_email = $this->language->get('entry_email');
$entry_password = $this->language->get('entry_password');
$button_continue = $this->language->get('button_continue');
$button_login = $this->language->get('button_login');
?> 
<div id="container">
<div id="cart-success"></div>
<div id="header">
  <?php if ($logo) { ?>
  <div id="logo"><a href="<?php echo $home; ?>"><img src="<?php echo $logo; ?>" title="<?php echo $name; ?>" alt="<?php echo $name; ?>" /></a></div>
  <?php } ?>
  <div class="triple"></div>
  <div class="tel"><?php echo $this->config->get('config_telephone'); ?></div>
  <?php echo $language; ?>
  <?php echo $currency; ?>
  <?php echo $cart; ?>
  <div id="search">
    <div class="button-search">Ara</div>
    <input type="text" name="search" placeholder="<?php echo $text_search; ?>" value="<?php echo $search; ?>" />
  </div>
  <div id="welcome">
    <?php if (!$logged) { ?>
    <?php echo $text_welcome; ?>
    <?php } else { ?>
    <?php echo $text_logged; ?>
    <?php } ?>
  </div>
  <div class="links"><a style="padding-left:33px;"class="icon-home" href="<?php echo $home; ?>"><?php echo $text_home; ?></a> <a href="<?php echo $wishlist; ?>" id="wishlist-total" class="icon-wishlist-white"><?php echo $text_wishlist; ?></a>
  <a href="<?php echo $account; ?>"class="icon-user-white"><?php echo $text_account; ?></a>
  <a href="<?php echo $shopping_cart; ?>" class="icon-cart-white"><?php echo $text_shopping_cart; ?></a>
  <a href="<?php echo $checkout; ?>" class="icon-checkout-white"><?php echo $text_checkout; ?></a></div></div>
<?php if ($categories) { ?>
<div id="menu">
  <ul id="menu_mobile">
    <li><a href="javascript:none" onClick="document.getElementById('menu_mobile').style.display='none';document.getElementById('menu_normal').style.display='block'">MENU</a></li>
        </ul>
         <ul id="menu_normal">
		 
		 <li><a href="<?php echo $home; ?>"><?php echo $text_home; ?></a>
        
      </li>
		 
    <?php foreach ($categories as $category) { ?>
    <li><a href="<?php echo $category['href']; ?>"><?php echo $category['name']; ?></a>
      <?php if ($category['children']) { ?>
      <div>
        <?php for ($i = 0; $i < count($category['children']);) { ?>
        <ul>
          <?php $j = $i + ceil(count($category['children']) / $category['column']); ?>
          <?php for (; $i < $j; $i++) { ?>
          <?php if (isset($category['children'][$i])) { ?>
          <li><a href="<?php echo $category['children'][$i]['href']; ?>"><?php echo $category['children'][$i]['name']; ?></a></li>
          <?php } ?>
          <?php } ?>
        </ul>
        <?php } ?>
      </div>
      <?php } ?>
    </li>
    <?php } ?>
	
		 
		 <li><a href="index.php?route=module/allcategories">DİĞER TÜM KATEGORİLER</a>

      </li>
	  
	  <li><a href="<?php echo $contact; ?>"  ><?php echo $text_contact; ?></a>
      <div style="width:130px;color:#ccc;padding:10px;">
          <div >
          
          <ul><li style="text-transform:uppercase;font-weight:bold;"><a href="#"><?php echo $text_location; ?></a><br></li>
             <li><b><?php echo $text_address; ?></b> <?php echo $address; ?><br><br></li>
             <li><?php if ($telephone) { ?>
                  <b><?php echo $text_telephone; ?></b> <?php echo $telephone; ?><br><br>
                 <?php } ?></li>
             <li> <?php if ($fax) { ?>
                   <b><?php echo $text_fax; ?></b> <?php echo $fax; ?><br><br>
                   <?php } ?></li> 
<li> <a href="mailto:<?php echo $this->config->get('config_email'); ?>"><?php echo $this->config->get('config_email'); ?></a>  </li>				   

          </ul>
        </div>
        </div>
      </li>
  </ul>
</div>
<?php } ?>
<div class="orta">
<div id="notification"></div>
