<?php
/*
  $Id: OPENCART WEBPOS PRO V.2.0

  Webpos Pro, Open Source E-Commerce Payment Solutions

  Coded by Yavuz Yasin Dzgn (duzgun)
  Copyright (c) http://www.duzgun.com , http://www.opencart.com.tr

  Released under the GNU General Public License
*/
class ModelTotalTaksit extends Model {
public function getTotal(&$total_data, &$total, &$taxes) {
$this->load->language('total/taksit');

if (isset($this->session->data['webpos']['selector']) && $this->session->data['webpos']['selector'][1]>0 && $this->config->get('taksit_status')) {
$api = $this->session->data['webpos']['selector'][0];
$taksitsayisi = $this->session->data['webpos']['selector'][1];
$vadefarki = $this->session->data['webpos']['selector'][2];
$vadefarkivergisi = $this->config->get('webpos_taksit_tax');

$Taksit = (int)$taksitsayisi;
$Taksit_Oran = (float)$vadefarki;
$Taksit_SubTotal = 0;

foreach ($this->cart->getProducts() as $product) {
$VadeFarki = $product['total'] * $Taksit_Oran / 100;
if ($product['tax_class_id'] && $vadefarkivergisi) {
$tax_rates = $this->tax->getRates($VadeFarki, $product['tax_class_id']);
foreach ($tax_rates as $tax_rate) {
if (!isset($taxes[$tax_rate['tax_rate_id']])) {
$taxes[$tax_rate['tax_rate_id']] = $tax_rate['amount'];
} else {
$taxes[$tax_rate['tax_rate_id']] += $tax_rate['amount'];
} 
}
}
$Taksit_SubTotal += $VadeFarki;
}
$total_data[] = array(
'code'       => 'taksit',
'title'      =>  sprintf($this->language->get('text_extra'), $Taksit),
'text'       => $this->currency->format($Taksit_SubTotal),
'value'      => $Taksit_SubTotal,
'sort_order' => $this->config->get('taksit_sort_order')
);

$total += $Taksit_SubTotal;


}

}

}
?>
