<?php
class ModelTotalPaymentFee extends Model {
	public function getTotal(&$total_data, &$total, &$taxes) {
		if ($this->config->get('payment_fee_status') && $this->config->get('payment_fee') && isset($this->session->data['payment_method']['code'])) {
			$result = unserialize($this->config->get('payment_fee'));

			foreach($result as $results) {
				if (in_array($this->session->data['payment_method']['code'], $results) && isset($results['fee_m']) && $this->cart->getSubTotal() > $results['fee_m']) {

                $this->load->model('account/address');

    			if ($this->customer->isLogged()) {
    				$shipping_address = $this->model_account_address->getAddress($this->session->data['shipping_address_id']);
    			} elseif (isset($this->session->data['guest'])) {
    				$shipping_address = $this->session->data['guest']['shipping'];
    			}

				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('payment_fee_geo_zone_id') . "' AND country_id = '" . (int)$shipping_address['country_id'] . "' AND (zone_id = '" . (int)$shipping_address['zone_id'] . "' OR zone_id = '0')");

							if (!$this->config->get('payment_fee_geo_zone_id')) {
								$status = TRUE;
							} elseif ($query->num_rows) {
								$status = TRUE;
							} else {
								$status = FALSE;
							}

					if ($status) {
						$this->load->language('total/payment_fee');

	                    if ($results['type'] == 'F') {
    						if (isset($results['fee_f']) && $results['fee_p'] === null)
    							$fee = $total + $results['fee_f'];
    						elseif (isset($results['fee_p']) && $results['fee_f'] === null)
    							$fee = - ((($results['fee_p'] / 100) * $total) / (($results['fee_p'] / 100) - 1));
    						elseif (isset($results['fee_p']) && isset($results['fee_f']))
    							$fee = -($results['fee_f'] / (($results['fee_p'] / 100) - 1)) - ((($results['fee_p'] / 100) * $total) / (($results['fee_p'] / 100) - 1));
                            $title = $this->language->get('text_payment_fee');
                            $value = $fee;
                            $text = $this->currency->format($fee);
                        } else {
                            if (isset($results['fee_f']) && $results['fee_p'] === null)
    							$fee = $total - $results['fee_f'];
    						elseif (isset($results['fee_p']) && $results['fee_f'] === null)
    							$fee = $total / 100 * $results['fee_p'];
    						elseif (isset($results['fee_p']) && isset($results['fee_f']))
    							$fee = $total / 100 * $results['fee_p'] + $results['fee_f'];
                            $title = $this->language->get('text_payment_discount');
                            $value = -$fee;
                            $text = $this->currency->format(-$fee);
                        }

  						$this->load->model('localisation/currency');

  						$total_data[] = array(
                            'code'       => 'payment_fee',
  							'title'      => $title,
  							'text'       => $text,
  							'value'      => $value,
  							'sort_order' => $this->config->get('payment_fee_sort_order')
  						);

                        if ($this->config->get('payment_fee_tax_class_id')) {
            				$tax_rates = $this->tax->getRates($fee, $this->config->get('payment_fee_tax_class_id'));

            				foreach ($tax_rates as $tax_rate) {
            					if (!isset($taxes[$tax_rate['tax_rate_id']])) {
            						$taxes[$tax_rate['tax_rate_id']] = $tax_rate['amount'];
            					} else {
            						$taxes[$tax_rate['tax_rate_id']] += $tax_rate['amount'];
            					}
            				}
            			}

                        if ($results['type'] == 'F') {
						    $total += $fee;
                        } else {
                            $total -= $fee;
                        }
					}
				}
			}
		}
	}
}
?>