<?php
class ModelShippingSpecialShipping extends Model {
	function getQuote($address) {
		$this->load->language('shipping/special_shipping');
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('special_shipping_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");
	
		if (!$this->config->get('special_shipping_geo_zone_id')) {
			$status = true;
		} elseif ($query->num_rows) {
			$status = true;
		} else {
			$status = false;
		}

		if ($this->cart->getSubTotal() >= 127.00) {
			$status = false;
		}
		
		$method_data = array();
	
		if ($status) {
			$have_special = false;
			
			$special_shipping_products = json_decode($this->config->get('special_shipping_products'));
			foreach ($this->cart->getProducts() as $product) {
				if (array_search($product['product_id'], $special_shipping_products) !== false) {
					$have_special = true;
				}
			}
			
			if ($have_special) {
				$quote_data = array();
				
				$quote_data['special_shipping'] = array(
					'code'         => 'special_shipping.special_shipping',
					'title'        => $this->language->get('text_description'),
					'cost'         => $this->config->get('special_shipping_cost'),
					'tax_class_id' => $this->config->get('special_shipping_tax_class_id'),
					'text'         => $this->currency->format($this->tax->calculate($this->config->get('special_shipping_cost'), $this->config->get('special_shipping_tax_class_id'), $this->config->get('config_tax')))

				);

				$method_data = array(
					'code'       => 'special_shipping',
					'title'      => $this->language->get('text_title'),
					'quote'      => $quote_data,
					'sort_order' => $this->config->get('special_shipping_sort_order'),
					'error'      => false
				);
			}
		}
	
		return $method_data;
	}
}
?>