<?php
class ControllerModuleFeaturedTabs extends Controller {
	protected function index($setting) {
		$this->language->load('module/featuredtabs');
 
      	$this->data['heading_title'] = $this->language->get('heading_title');
		$this->document->addScript('catalog/view/javascript/jquery/tabs.js');		
		$this->data['tab_bestseller'] = $this->language->get('tab_bestseller');
		$this->data['tab_featured'] = $this->language->get('tab_featured');
		$this->data['tab_latest'] = $this->language->get('tab_latest');
		$this->data['tab_special'] = $this->language->get('tab_special');
		$this->data['button_cart'] = $this->language->get('button_cart');
		$this->load->model('catalog/product');
		
		$this->load->model('tool/image');
		//bestseller(en cok satanlar)
		$this->data['bestseller_products'] = array();

		/*$results = $this->model_catalog_product->getBestSellerProducts($setting['limit']);*/
		$results = $this->model_catalog_product->getBestSellerProducts($setting['limit'] * 10);
srand((float)microtime() * 1000000);
shuffle($results); 
$results = array_slice($results, 0, $setting['limit']);
		
		foreach ($results as $result) {
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], $setting['image_width'], $setting['image_height']);
			} else {
				$image = false;
			}
			
			if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
				$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$price = false;
			}
					
			if ((float)$result['special']) {
				$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$special = false;
			}	
			
			if ($this->config->get('config_review_status')) {
				$rating = $result['rating'];
			} else {
				$rating = false;
			}
							
			$this->data['bestseller_products'][] = array(
				'product_id' => $result['product_id'],
				'thumb'   	 => $image,
				'name'        => substr($result['name'], 0, 85) . '',
				'price'   	 => $price,
				'special' 	 => $special,
				'rating'     => $rating,
				'quantity' => $result['quantity'],
				'tarih'         => $result['date_added'], 
				'reviews'    => sprintf($this->language->get('text_reviews'), (int)$result['reviews']),
				'href'    	 => $this->url->link('product/product', 'product_id=' . $result['product_id']),
			);
		}
		// bestseller end
		//featured(ozel urunler)
		$this->data['featured_products'] = array();

		$products = explode(',', $this->config->get('featured_product'));		

		foreach ($products as $product_id) {
			$product_info = $this->model_catalog_product->getProduct($product_id);
			
			if ($product_info) {
				if ($product_info['image']) {
					$image = $this->model_tool_image->resize($product_info['image'], $setting['image_width'], $setting['image_height']);
				} else {
					$image = false;
				}

				if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')));
				} else {
					$price = false;
				}
						
				if ((float)$product_info['special']) {
					$special = $this->currency->format($this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')));
				} else {
					$special = false;
				}
				
				if ($this->config->get('config_review_status')) {
					$rating = $product_info['rating'];
				} else {
					$rating = false;
				}
					
				$this->data['featured_products'][] = array(
					'product_id' => $product_info['product_id'],
					'thumb'   	 => $image,
					'name'        => substr($product_info['name'], 0, 85) . '',
					'price'   	 => $price,
					'special' 	 => $special,
					'rating'     => $rating,
					'quantity' => $product_info['quantity'],
					'tarih'         => $product_info['date_added'], 
					'reviews'    => sprintf($this->language->get('text_reviews'), (int)$product_info['reviews']),
					'href'    	 => $this->url->link('product/product', 'product_id=' . $product_info['product_id']),
				);
			}
		}
		//featured end
		//latest (yeni urunler)
		$this->data['latest_products'] = array();
		
		$data = array(
			'sort'  => 'p.date_added',
			'order' => 'DESC',
			'start' => 0,
			'limit' => ($setting['limit']*10)
		);

		$results = $this->model_catalog_product->getProducts($data);
		srand((float)microtime() * 1000000);
shuffle($results); 
$results = array_slice($results, 0, $setting['limit']);

		foreach ($results as $result) {
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], $setting['image_width'], $setting['image_height']);
			} else {
				$image = false;
			}
						
			if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
				$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$price = false;
			}
					
			if ((float)$result['special']) {
				$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$special = false;
			}
			
			if ($this->config->get('config_review_status')) {
				$rating = $result['rating'];
			} else {
				$rating = false;
			}
			
			$this->data['latest_products'][] = array(
				'product_id' => $result['product_id'],
				'thumb'   	 => $image,
				'name'        => substr($result['name'], 0, 85) . '',
				'price'   	 => $price,
				'special' 	 => $special,
				'rating'     => $rating,
				'quantity' => $result['quantity'],
				'tarih'         => $result['date_added'], 
				'reviews'    => sprintf($this->language->get('text_reviews'), (int)$result['reviews']),
				'href'    	 => $this->url->link('product/product', 'product_id=' . $result['product_id']),
			);
		}
		//latest end
		//special(kampanyali urunler)
		$this->data['special_products'] = array();
		
		$data = array(
			'sort'  => 'pd.name',
			'order' => 'ASC',
			'start' => 0,
			'limit' => ($setting['limit']*10)
		);

		$results = $this->model_catalog_product->getProductSpecials($data);
		srand((float)microtime() * 1000000);
shuffle($results); 
$results = array_slice($results, 0, $setting['limit']);

		foreach ($results as $result) {
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], $setting['image_width'], $setting['image_height']);
			} else {
				$image = false;
			}

			if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
				$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$price = false;
			}
					
			if ((float)$result['special']) { 
				$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$special = false;
			}
			
			if ($this->config->get('config_review_status')) {
				$rating = $result['rating'];
			} else {
				$rating = false;
			}
			
			$this->data['special_products'][] = array(
				'product_id' => $result['product_id'],
				'thumb'   	 => $image,
				'name'        => substr($result['name'], 0, 85) . '',
				'price'   	 => $price,
				'special' 	 => $special,
				'rating'     => $rating,
				'quantity' => $result['quantity'],
				'tarih'         => $result['date_added'], 
				'reviews'    => sprintf($this->language->get('text_reviews'), (int)$result['reviews']),
				'href'    	 => $this->url->link('product/product', 'product_id=' . $result['product_id']),
			);
		}
		//

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/featuredtabs.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/featuredtabs.tpl';
		} else {
			$this->template = 'default/template/module/featuredtabs.tpl';
		}

		$this->render();
	}
}
?>