<?php 
//-----------------------------------------------------
// AmazonMenu for Opencart v1.5.1   
// Created by villagedefrance                          
// contact@villagedefrance.net                                       
//-----------------------------------------------------

class ControllerModuleAmazonMenu extends Controller {

	private $_name = 'amazonmenu';
	
	public function rewrite($link) {
		if ($this->config->get('config_seo_url')) {
			$url_data = parse_url(str_replace('&amp;', '&', $link));
			
			$url = ''; 
				
			$data = array();
			
			parse_str($url_data['query'], $data);
				
			foreach ($data as $key => $value) {
				if (($key == 'product_id') || ($key == 'manufacturer_id') || ($key == 'information_id')) {
					$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "url_alias WHERE `query` = '" . $this->db->escape($key . '=' . (int)$value) . "'");				
					if ($query->num_rows) {
						$url .= '/' . $query->row['keyword'];						
					unset($data[$key]);
				}					
			} elseif ($key == 'path') {
				$categories = explode('_', $value);					
					foreach ($categories as $category) {
						$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "url_alias WHERE `query` = 'category_id=" . (int)$category . "'");
						if ($query->num_rows) {
							$url .= '/' . $query->row['keyword'];
						}							
					}			
					unset($data[$key]);
				}
			}
			
			if ($url) {
				unset($data['route']);
				$query = '';
				if ($data) {
					foreach ($data as $key => $value) {
						$query .= '&' . $key . '=' . $value;
					}
					if ($query) {
						$query = '?' . trim($query, '&');
					}
				}
				return $url_data['scheme'] . '://' . $url_data['host'] . (isset($url_data['port']) ? ':' . $url_data['port'] : '') . str_replace('/index.php', '', $url_data['path']) . $url . $query;
			} else {
				return $link;
			}
		} else {
			return $link;
		}		
	}
	
	protected $category_id = 0;
	protected $path = array();
	
	protected function index() {
	
		$this->language->load('module/' . $this->_name);

      	$this->data['heading_title'] = $this->language->get('heading_title');

		$this->load->model('localisation/language');

		$languages = $this->model_localisation_language->getLanguages();
		
		foreach ($languages as $language) {
			if (isset($this->request->post[$this->_name . '_title' . $language['language_id']])) {
				$this->data[$this->_name . '_title' . $language['language_id']] = $this->request->post[$this->_name . '_title' . $language['language_id']];
			} else {
				$this->data[$this->_name . '_title' . $language['language_id']] = $this->config->get($this->_name . '_title' . $language['language_id']);
			}
		}
		
		$this->data['title'] = $this->config->get($this->_name . '_title' . $this->config->get('config_language_id'));

		$this->data['header'] = $this->config->get($this->_name . '_header');
		
		$this->data['icon'] = $this->config->get($this->_name . '_icon');
		
		if(!$this->data['title']) { 
			$this->data['title'] = $this->data['heading_title']; 
		} 
		if(!$this->data['header']) { 
			$this->data['title'] = ''; 
		}
		
		$this->data['hdcolor'] = $this->config->get($this->_name . '_hdcolor');
		$this->data['txcolor'] = $this->config->get($this->_name . '_txcolor');
		$this->data['theme'] = $this->config->get($this->_name . '_theme');
		$this->data['box'] = $this->config->get($this->_name . '_box');
		
		if (isset($this->request->get['path'])) {
			$this->path = explode('_', $this->request->get['path']);
			
			$this->category_id = end($this->path);
		}
		
		$this->data['category'] = $this->getCategories(0);
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/' . $this->_name . '.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/' . $this->_name . '.tpl';
		} else {
			$this->template = 'default/template/module/' . $this->_name . '.tpl';
		}
		
		$this->render();
  	}

	// --------------------------------------- Menu Generator ------------------------------------------- //
	
	protected function getCategories($parent_id, $current_path = '') {
		static $layer = 0;
		$category_id = array_shift($this->path);
		
		$output = '';
		
		$results = $this->model_catalog_category->getCategories($parent_id);
		
		if ($results) { 
			if ($layer > 0) {
				$output .= '<ul>';
			} else {
				$output .= '<ul id="nav">';
			}
			$layer = $layer + 1;
    	}
		$isfirst = 0;
		
		foreach ($results as $result) {	
			if (!$current_path) {
				$new_path = $result['category_id'];
			} else {
				$new_path = $current_path . '_' . $result['category_id'];
			}
			
			$children = '';
			$classname = '';
			
			$children = $this->getCategories($result['category_id'], $new_path);

			if ($layer >0)
			{
				if ($isfirst ==0 )
				{
					$classname = 'first';
				}
				$isfirst ++;
			}
			
			if ($this->category_id == $result['category_id']) {
				$output .= '<li class="onSelectedLi ' . $classname . '"><a title="' . $result['meta_description'] . '" href="' . $this->rewrite(HTTP_SERVER . 'index.php?route=product/category&amp;path=' . $new_path)  . '">' . $result['name'] . '</a>';
			} else {
				$output .= '<li class="' . $classname . '"><a title="' . $result['meta_description'] . '" href="' . $this->rewrite(HTTP_SERVER . 'index.php?route=product/category&amp;path=' . $new_path)  . '">' . $result['name'] . '</a>';
			}
        	$output .= $children;
        
        	$output .= '</li>'; 
		}
		
		if ($results) {
			
			$output .= '</ul>';
		}
		
		return $output;
	}		
}
?>