<?php
#####################################################################################
#  HBU XML EXPORTER MODULU 1.0 Opencart 1.5.x icin uygundur opencart.demosu.org 	#
#####################################################################################
class ControllerFeedHbuExport extends Controller {
	private $names = array();
	private $input_fields = array(
		'hbu_export_field_product_id' => 'product_id',
		'hbu_export_field_url' => 'url',
		'hbu_export_field_name' => 'name',
		'hbu_export_field_image' => 'image',
		'hbu_export_field_EkResim' => 'EkResim',
		'hbu_export_field_price' => 'price',
		'hbu_export_field_desc' => 'description',
		'hbu_export_field_cat' => 'category',
		'hbu_export_field_manu' => 'manufacturer',
		'hbu_export_field_model' => 'model',
		'hbu_export_field_sku' => 'sku',
		'hbu_export_field_quantity' => 'quantity',
		'hbu_export_field_added' => 'date_added',
		'hbu_export_field_views' => 'viewed',
		'hbu_export_field_specialprice' => 'special_price',
		'hbu_export_field_stockstatus' => 'stock_status_id',
		'hbu_export_field_length' => 'length',
		'hbu_export_field_width' => 'width',
		'hbu_export_field_height' => 'height',
		'hbu_export_field_upc' => 'upc',
		'hbu_export_field_location' => 'location',
		'hbu_export_field_points' => 'points',
		'hbu_export_field_date_available' => 'date_available',
		'hbu_export_field_weight' => 'weight',
		'hbu_export_field_shipping' => 'shipping',
		'hbu_export_field_status' => 'status',
		'hbu_export_field_date_modified' => 'date_modified',
		'hbu_export_field_meta_keyword' => 'meta_keyword',
		'hbu_export_field_discount' => 'discount',
		'hbu_export_field_special' => 'special',
		'hbu_export_field_reward' => 'reward',
		'hbu_export_field_rating' => 'rating',
	);

	public function index() {
		if ($this->config->get('hbu_export_status')) { 
			
			$this->load->model('feed/hbu_export');
			$stock_statuses = $this->model_feed_hbu_export->getStockStatus();
			
			if ($this->config->get('hbu_export_format')) {
				$format = 'xml';
			}
			else {
				$format = 'csv';
							
				if ($this->config->get('hbu_export_delimiter')) {
					$delim = $this->config->get('hbu_export_delimiter');
				} else {
					$delim = ',';
				}
				if ($delim == '\t') {
					$delim = "\t";
				}
			}
			$order = explode(",", $this->config->get('hbu_export_order'));
			
			$fields = array();
			foreach ($order as $field) {
				$fields[] = $this->input_fields[$field];
				if ($this->config->get($field."name")) {
					$this->names[$field] = $this->config->get($field."name");
				}else {
					$this->names[$field] = $this->input_fields[$field];
				}
			}
			
			// HEADINGS FOR CSV or XML
			if ($format == 'csv') {
				$output = join($delim, $this->names) . "\n";
			}
			else {
				$output = "<?xml version=\"1.0\"?>\n<hbu_exporter_urunler>\n";
			}
						
			$this->load->model('catalog/category');
			
			$this->load->model('catalog/product');
			
			//Allow start and limit for DB query - a fix for large feeds.
			$data = array();
			if (isset($this->request->get['start'])) {
				$data['start'] = $this->request->get['start'];
				$data['limit'] = 50000;
			}
			if (isset($this->request->get['numResults'])) {
				$data['limit'] = $this->request->get['numResults'];
			}
			
			$products = $this->model_catalog_product->getProducts($data);
			
			foreach ($products as $product) {
				// clean description html
				
				$product['description'] = strip_tags($product['description']);
					
				// get categories
				$categories = $this->model_catalog_product->getCategories($product['product_id']);
				$thiscat = '';
				foreach ($categories as $category) {
					$catpath = $this->getCatInfo($category['category_id']);
					
					if ($catpath) {
						$thiscat = '';
						foreach (explode('_', $catpath) as $pathid) {
							$cat = $this->model_catalog_category->getCategory($pathid);
							
							if ($cat) {
								if (!$thiscat) {
									$thiscat = $cat['name'];
								} else {
									$thiscat .= ' : ' . $cat['name'];
								}
							}
						}
					}
				}
				$product['category'] = $thiscat;
				
				foreach ($stock_statuses as $ss) {
					if ($product['stock_status_id'] == $ss['stock_status_id']) {
						$product['stock_status_id'] = $ss['name'];
					}
				}
				$product['special_price'] = $product['special'];
				// Aaki satr KDV dahil fiyatlar getirsin diye var. O yzden pasif edildi. 
				// $product['price'] = $this->currency->format($this->tax->calculate($product['price'], $product['tax_class_id'], $this->config->get('config_tax')));
		
					
                $product['url'] = html_entity_decode($this->url->link('product/product', 'product_id=' . $product['product_id'], 'SSL'));
				
				if ($product['image']) {
					$product['image'] = HTTP_SERVER . "image/" . $product['image'];
				} else {
					$product['image'] = '';
				}

				$prod = array();
					
				foreach ($order as $key) {
					if (isset ($product[$this->input_fields[$key]])) {
						$prod[$this->names[$key]] = $product[$this->input_fields[$key]];
					}
					else {
						$prod[$this->names[$key]] = '';
					}
				}
					
						
				if ($format == 'csv') {
					$output .= $this->outputCSV($prod, $delim);
				}
				else {
					$output .= $this->outputXML($prod);
				}
			}
			
			
			if ($format == 'xml') {
				$output .= "</hbu_exporter_urunler>";
				$this->response->addHeader('Content-Type: application/xml');
			} 
			else {
				$this->response->addheader('Pragma: public');
				$this->response->addheader('Expires: 0');
				$this->response->addheader('Content-Type: application/octet-stream');
				$this->response->addheader('Content-Description: File Transfer');
				$this->response->addheader('Content-Disposition: attachment; filename=opencart_products.csv');
				$this->response->addheader('Content-Transfer-Encoding: binary');
			}
			

			$this->response->setOutput($output, 0);
		} else {
			$this->redirect($this->url->link('common/home'));
		}
	}	
	
	protected function outputXML($product) {
		$result = "<Urun>\n";
		foreach ($product as $key => $value) {
			$value = str_replace('&', '&amp;', $value);
			$value = str_replace('>', '&gt;', $value);
			$value = str_replace('<', '&lt;', $value);
			if ($this->config->get("hbu_export_cdata")) {
				$value = "<![CDATA[" . $value . "]]>";
			}
			$product[$key] = "<" . $key . ">";
			$product[$key] .= $value; 
			$product[$key] .= "</" . $key . ">";
		}
		//Bo bir zamannda rn seeneklerini ve rn zelliklerini de XML ye semeli olarak entegre etmek iin ura
		// seenekleri burada ekiyor.
		// include ("secenek_exporter.php");
		// seenekleri ekme sonu
		
		// ek resim linklerini burada ekiyor
		include ("EkResim_cek.php");
		include ("vergi_cek.php");
		include ("Tag_cek.php");
		// ek resim sonu
		
		$result .= join("\n", $product);
		$result .= "\n</Urun>\n";
		return $result;
	}			
	
	protected function outputCSV($product, $delim) {
		foreach ($product as $key => $value) {
			$value = str_replace('"', '""', $value);
			$product[$key] = '"' . $value . '"';
		}
		$result = join($delim, $product);
		$result .= "\n";
		return $result;
	}
	
	protected function getCatInfo($parent_id, $current_path = '') {
		$category_info = $this->model_catalog_category->getCategory($parent_id);
	
		if ($category_info) {
			if (!$current_path) {
				$new_path = $category_info['category_id'];
			} else {
				$new_path = $category_info['category_id'] . '_' . $current_path;
			}	
		
			$path = $this->getCatInfo($category_info['parent_id'], $new_path);
					
			if ($path) {
				return $path;
			} else {
				return $new_path;
			}
		}
	}

}
?>